/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5431;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private final class_2338.class_2339 scratchPos = new class_2338.class_2339();
    private final MutableFloat scratchHeight = new MutableFloat(0.0f);
    private final MutableInt scratchSamples = new MutableInt();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final ColorBlender colorBlender;
    private final FabricFluidColorizerAdapter fabricColorProviderAdapter = new FabricFluidColorizerAdapter();
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();

    public FluidRenderer(LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.quad.setNormal(Norm3b.pack(0.0f, 1.0f, 0.0f));
        this.lighters = lighters;
        this.colorBlender = colorBlender;
    }

    private boolean isFluidOccluded(class_1920 world, int x, int y, int z, class_2350 dir, class_3611 fluid) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x, y, z);
        class_2680 blockState = world.method_8320((class_2338)pos);
        class_2338.class_2339 adjPos = this.scratchPos.method_10103(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        if (blockState.method_26225()) {
            return world.method_8316((class_2338)adjPos).method_15772().method_15780(fluid) || blockState.method_30368((class_1922)world, (class_2338)pos, dir, class_5431.field_25822);
        }
        return world.method_8316((class_2338)adjPos).method_15772().method_15780(fluid);
    }

    private boolean isSideExposed(class_1920 world, int x, int y, int z, class_2350 dir, float height) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        class_2680 blockState = world.method_8320((class_2338)pos);
        if (blockState.method_26225()) {
            class_265 shape = blockState.method_26201((class_1922)world, (class_2338)pos);
            if (shape == class_259.method_1077()) {
                return dir == class_2350.field_11036;
            }
            if (shape.method_1110()) {
                return true;
            }
            class_265 threshold = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !class_259.method_1083((class_265)threshold, (class_265)shape, (class_2350)dir);
        }
        return true;
    }

    public boolean render(class_1920 world, class_3610 fluidState, class_2338 pos, class_2338 offset, ChunkModelBuilder buffers) {
        float h4;
        float h3;
        float h2;
        float h1;
        int posX = pos.method_10263();
        int posY = pos.method_10264();
        int posZ = pos.method_10260();
        class_3611 fluid = fluidState.method_15772();
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11036, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11033, fluid) || !this.isSideExposed(world, posX, posY, posZ, class_2350.field_11033, 0.8888889f);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11043, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11035, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11039, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11034, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return false;
        }
        boolean isWater = fluidState.method_15767(class_3486.field_15517);
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.method_15772());
        if (handler == null) {
            boolean isLava = fluidState.method_15767(class_3486.field_15518);
            handler = FluidRenderHandlerRegistry.INSTANCE.get((class_3611)(isLava ? class_3612.field_15908 : class_3612.field_15910));
        }
        ColorSampler<class_3610> colorizer = this.createColorProviderAdapter(handler);
        class_1058[] sprites = handler.getFluidSprites(world, pos, fluidState);
        boolean rendered = false;
        float fluidHeight = this.fluidHeight(world, fluid, pos);
        if (fluidHeight >= 1.0f) {
            h1 = 1.0f;
            h2 = 1.0f;
            h3 = 1.0f;
            h4 = 1.0f;
        } else {
            float north1 = this.fluidHeight(world, fluid, pos.method_10095());
            float south1 = this.fluidHeight(world, fluid, pos.method_10072());
            float east1 = this.fluidHeight(world, fluid, pos.method_10078());
            float west1 = this.fluidHeight(world, fluid, pos.method_10067());
            h1 = this.fluidCornerHeight(world, fluid, fluidHeight, north1, west1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
            h2 = this.fluidCornerHeight(world, fluid, fluidHeight, south1, west1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
            h3 = this.fluidCornerHeight(world, fluid, fluidHeight, south1, east1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
            h4 = this.fluidCornerHeight(world, fluid, fluidHeight, north1, east1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
        }
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && class_310.method_1588() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, class_2350.field_11036, Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            class_1058 sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            class_243 velocity = fluidState.method_15758((class_1922)world, pos);
            if (velocity.field_1352 == 0.0 && velocity.field_1350 == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.UP;
                u1 = sprite.method_4580(0.0);
                v1 = sprite.method_4570(0.0);
                u2 = u1;
                v2 = sprite.method_4570(16.0);
                u3 = sprite.method_4580(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) - 1.5707964f;
                float sin = class_3532.method_15374((float)dir) * 0.25f;
                float cos = class_3532.method_15362((float)dir) * 0.25f;
                u1 = sprite.method_4580((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.method_4570((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.method_4580((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.method_4570((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.method_4580((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.method_4570((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.method_4580((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.method_4570((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].method_45851().method_45807() / (sprites[0].method_4577() - sprites[0].method_4594());
            float s2 = (float)sprites[0].method_45851().method_45815() / (sprites[0].method_4575() - sprites[0].method_4593());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = class_3532.method_16439((float)s3, (float)u1, (float)uAvg);
            u2 = class_3532.method_16439((float)s3, (float)u2, (float)uAvg);
            u3 = class_3532.method_16439((float)s3, (float)u3, (float)uAvg);
            u4 = class_3532.method_16439((float)s3, (float)u4, (float)uAvg);
            v1 = class_3532.method_16439((float)s3, (float)v1, (float)vAvg);
            v2 = class_3532.method_16439((float)s3, (float)v2, (float)vAvg);
            v3 = class_3532.method_16439((float)s3, (float)v3, (float)vAvg);
            v4 = class_3532.method_16439((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, h1, 0.0f, u1, v1);
            FluidRenderer.setVertex(quad, 1, 0.0f, h2, 1.0f, u2, v2);
            FluidRenderer.setVertex(quad, 2, 1.0f, h3, 1.0f, u3, v3);
            FluidRenderer.setVertex(quad, 3, 1.0f, h4, 0.0f, u4, v4);
            this.updateQuad(quad, world, pos, lighter, class_2350.field_11036, 1.0f, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, facing, ModelQuadWinding.CLOCKWISE);
            if (fluidState.method_15756((class_1922)world, (class_2338)this.scratchPos.method_10103(posX, posY + 1, posZ))) {
                this.writeQuad(buffers, offset, quad, ModelQuadFacing.DOWN, ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        if (!sfDown) {
            class_1058 sprite = sprites[0];
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            FluidRenderer.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            FluidRenderer.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            FluidRenderer.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.updateQuad(quad, world, pos, lighter, class_2350.field_11033, 1.0f, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, ModelQuadFacing.DOWN, ModelQuadWinding.CLOCKWISE);
            rendered = true;
        }
        quad.setFlags(4);
        block6: for (class_2350 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            class_2338.class_2339 adjPos;
            class_2680 adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case field_11043: {
                    if (sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case field_11035: {
                    if (sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case field_11039: {
                    if (sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case field_11034: {
                    if (sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.method_10148();
            int adjY = posY + dir.method_10164();
            int adjZ = posZ + dir.method_10165();
            class_1058 sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent((adjBlock = world.method_8320((class_2338)(adjPos = this.scratchPos.method_10103(adjX, adjY, adjZ)))).method_26204())) {
                sprite = sprites[2];
                isOverlay = true;
            }
            float u1 = sprite.method_4580(0.0);
            float u2 = sprite.method_4580(8.0);
            float v1 = sprite.method_4570((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.method_4570((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.method_4570(8.0);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, x2, c2, z2, u2, v2);
            FluidRenderer.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            FluidRenderer.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            FluidRenderer.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.method_10166() == class_2350.class_2351.field_11051 ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.updateQuad(quad, world, pos, lighter, dir, br, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, facing, ModelQuadWinding.CLOCKWISE);
            if (!isOverlay) {
                this.writeQuad(buffers, offset, quad, facing.getOpposite(), ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        return rendered;
    }

    private ColorSampler<class_3610> createColorProviderAdapter(FluidRenderHandler handler) {
        FabricFluidColorizerAdapter adapter = this.fabricColorProviderAdapter;
        adapter.setHandler(handler);
        return adapter;
    }

    private void updateQuad(ModelQuadView quad, class_1920 world, class_2338 pos, LightPipeline lighter, class_2350 dir, float brightness, ColorSampler<class_3610> colorSampler, class_3610 fluidState) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false);
        int[] biomeColors = this.colorBlender.getColors(world, pos, quad, colorSampler, fluidState);
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private void writeQuad(ChunkModelBuilder builder, class_2338 offset, ModelQuadView quad, ModelQuadFacing facing, ModelQuadWinding winding) {
        ChunkVertexBufferBuilder vertexBuffer = builder.getVertexBuffer();
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[i];
            out.x = (float)offset.method_10263() + quad.getX(i);
            out.y = (float)offset.method_10264() + quad.getY(i);
            out.z = (float)offset.method_10260() + quad.getZ(i);
            out.color = this.quadColors[i];
            out.u = quad.getTexU(i);
            out.v = quad.getTexV(i);
            out.light = this.quadLightData.lm[i];
        }
        class_1058 sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        builder.getIndexBuffer(facing).add(vertexBuffer.push(vertices), winding);
    }

    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float fluidCornerHeight(class_1920 world, class_3611 fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, class_2338 blockPos) {
        if (fluidHeightY >= 1.0f || fluidHeightX >= 1.0f) {
            return 1.0f;
        }
        if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
            float height = this.fluidHeight(world, fluid, blockPos);
            if (height >= 1.0f) {
                return 1.0f;
            }
            this.modifyHeight(this.scratchHeight, this.scratchSamples, height);
        }
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeight);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightY);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightX);
        float result = this.scratchHeight.floatValue() / (float)this.scratchSamples.intValue();
        this.scratchHeight.setValue(0.0f);
        this.scratchSamples.setValue(0);
        return result;
    }

    private void modifyHeight(MutableFloat totalHeight, MutableInt samples, float target) {
        if (target >= 0.8f) {
            totalHeight.add(target * 10.0f);
            samples.add(10);
        } else if (target >= 0.0f) {
            totalHeight.add(target);
            samples.increment();
        }
    }

    private float fluidHeight(class_1920 world, class_3611 fluid, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        class_3610 fluidState = blockState.method_26227();
        if (fluid.method_15780(fluidState.method_15772())) {
            class_3610 fluidStateUp = world.method_8316(blockPos.method_10084());
            if (fluid.method_15780(fluidStateUp.method_15772())) {
                return 1.0f;
            }
            return fluidState.method_20785();
        }
        if (!blockState.method_26207().method_15799()) {
            return 0.0f;
        }
        return -1.0f;
    }

    private static class FabricFluidColorizerAdapter
    implements ColorSampler<class_3610> {
        private FluidRenderHandler handler;

        private FabricFluidColorizerAdapter() {
        }

        public void setHandler(FluidRenderHandler handler) {
            this.handler = handler;
        }

        @Override
        public int getColor(class_3610 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
            if (this.handler == null) {
                return -1;
            }
            return this.handler.getFluidColor(world, pos, state);
        }
    }
}

