/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1937;
import net.minecraft.class_4076;

public class ClonedChunkSectionCache {
    private final class_1937 world;
    private final ConcurrentLinkedQueue<ClonedChunkSection> inactivePool = new ConcurrentLinkedQueue();
    private final Long2ReferenceMap<ClonedChunkSection> byPosition = new Long2ReferenceOpenHashMap();

    public ClonedChunkSectionCache(class_1937 world) {
        this.world = world;
    }

    public ClonedChunkSection acquire(int x, int y, int z) {
        long key = class_4076.method_18685((int)x, (int)y, (int)z);
        ClonedChunkSection section = (ClonedChunkSection)this.byPosition.get(key);
        if (section != null) {
            this.inactivePool.remove(section);
        } else {
            section = this.createSection(x, y, z);
        }
        section.acquireReference();
        return section;
    }

    private ClonedChunkSection createSection(int x, int y, int z) {
        ClonedChunkSection section;
        if (!this.inactivePool.isEmpty()) {
            section = (ClonedChunkSection)this.inactivePool.remove();
            this.byPosition.remove(section.getPosition().method_18694());
        } else {
            section = this.allocate();
        }
        class_4076 pos = class_4076.method_18676((int)x, (int)y, (int)z);
        section.init(this.world, pos);
        this.byPosition.put(pos.method_18694(), (Object)section);
        return section;
    }

    public void invalidate(int x, int y, int z) {
        this.byPosition.remove(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    public void release(ClonedChunkSection section) {
        if (section.releaseReference()) {
            this.tryReclaim(section);
        }
    }

    private ClonedChunkSection allocate() {
        return new ClonedChunkSection(this);
    }

    private void tryReclaim(ClonedChunkSection section) {
        this.inactivePool.add(section);
    }
}

