/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.reflection;

import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtil {
    public static boolean hasMethodOverride(Class<?> clazz, Class<?> superclass, boolean fallbackResult, String methodName, Class<?> ... methodArgs) {
        while (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                clazz.getDeclaredMethod(methodName, methodArgs);
                return true;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (NoClassDefFoundError error) {
                Logger logger = LogManager.getLogger((String)"Lithium Class Analysis");
                logger.warn("Lithium Class Analysis Error: Class " + clazz.getName() + " cannot be analysed, because getting declared methods crashes with NoClassDefFoundError: " + error.getMessage() + ". This is usually caused by modded entities declaring methods that have a return type or parameter type that is annotated with @Environment(value=EnvType.CLIENT). Loading the type is not possible, because it only exists in the CLIENT environment. The recommended fix is to annotate the method with this argument or return type with the same annotation. Lithium handles this error by assuming the class cannot be included in some optimizations.");
                return fallbackResult;
            }
            catch (Throwable e) {
                String crashedClass = clazz.getName();
                class_128 crashReport = class_128.method_560((Throwable)e, (String)"Lithium Class Analysis");
                class_129 crashReportSection = crashReport.method_562(e.getClass().toString() + " when getting declared methods.");
                crashReportSection.method_578("Analyzed class", (Object)crashedClass);
                crashReportSection.method_578("Analyzed method name", (Object)methodName);
                crashReportSection.method_578("Analyzed method args", methodArgs);
                throw new class_148(crashReport);
            }
        }
        return false;
    }
}

